\version "2.24.0"
\language "deutsch"

\paper {
 left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 9\mm
  ragged-last-bottom=##f
  system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Nădejdea mea"
  composer = \markup \center-column { "arm. prof. T. Sechei" \small "Dej, 20 martie 2001" }
  tagline = ""
  %meter = "Religioso"
}

global = {
  \key g \major
  \time 4/4
  \autoBeamOff
  \set Staff.midiInstrument = "clarinet"
}

stanzaOne = \lyricmode {
  Nă -- dej -- dea mea E nu -- mai la Ti -- ne Doam -- ne;
  că Tu ai  zis,  că Tu ai  zis, când ai ve -- nit în lu -- me:
  'Ve -- niţi, ve -- niţi, la Mi -- ne, 
  ve -- niţi, ve -- niţi, la Mi -- ne,
  Toţi cei o -- ste -- niţi şi îm -- po -- vă -- raţi
  şi Eu vă voi o -- dih -- ni pe voi.
  Ve- voi' 
  A -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a.
}

menWords =  \lyricmode {
  \skip 4 \skip 1 \skip 2 \skip 4
  Nă -- dej -- \skip 4 dea \skip 4 mea
}

sopranMusic = \relative c'' {
  \partial 4 h4^\mp c2 h4( a) h2. b4\rest b1\rest b1\rest
  e,4 fis g a^\< h2. a4\! g2^\>( fis\!) e2. h'4 e2^\f d4( c) h2. h4 e2 d4( c) h2. 
  e,4 e^\mf g h a g2( fis) e2. h'4
  
  \repeat volta 2 {
   e2.^\f h4 d4. d8 c2 h2. h4 e2. h4 d4. d8 c2 h2. b4\rest e,^\mf fis g^\< a h2.\! 
   b4\rest e, fis g^\< a h2.\! a4 
   \override BreathingSign.text = \markup {
             \musicglyph "scripts.caesura.straight" }
   h2 \fermata \breathe 
   a4 g^\> fis a g fis\!
  }
  \alternative {
  	  { e2. h'4 }
  	  { e,2. b'4\rest }
  }
  h4^\p h c a h2. b4\rest e, fis g a h2. b4\rest c^\> h8[( a)] g4 fis^\pp e2. \fermata
  \bar "|."
}

altMusic = \relative c'' {
  \partial 4 h4 a2 g4( fis) e2. b'4\rest b1\rest b1\rest
  e,4 dis e fis g2. fis4 e2( dis) e2. e4 g2 fis d2. e4 g2 fis d2. e4 e g g fis
  e2( dis) e2. e4 
    
  \repeat volta 2 {
    g2. g4 g4. g8 fis2 d2. e4 g2. g4 g4. g8 fis2 d2. b'4\rest e, dis e fis g2. b4\rest e, 
    dis e fis g2. fis4 g2 fis4 e dis fis e dis    
  }
  \alternative {
  	  { e2. e4 }
  	  { e2. b'4\rest }
  }
  g4 g g fis g2. b4\rest e, dis e fis g2. b4\rest a g8[( fis)] e4 dis e2.
}  	

tenorMusic = \relative c' {
  \partial 4 d,4\rest d1\rest d2\rest d4\rest h'4
  c2 h4( a) h2. d,4\rest g a h d d2. c4 h2( a) g2. g4 c2 h4( a) g2. g4 c2 h4( a) g2. 
  g4 g h d c h2( a) g2. g4
    
   \repeat volta 2 {
    c2. g4 h4. h8 a2 g2. g4 c2. g4 h4. h8 a2 g2. d4\rest g a h d d2. d,4\rest g a h d d2.
    d4 d2 c4 h h h h a    
    }
     \alternative {
  	  { g2. g4 }
  	  { g2. d4\rest }
     }
  h'4 h a c h2. d,4\rest g a h d d2. d,4\rest d' d8[( c)] h4 a g2.
}

bassMusic = \relative c {
  \clef bass \partial 4 d4\rest d1\rest d2\rest d4\rest h'4
  a2 g4( fis) e2. d4\rest e h e d g2. a4 h2( h,) e2. e4 c2 d g2. e4  c2 d g2. e4 
  e d g a h2( h,) e2. e4
  
  \repeat volta 2 {
   c2. d4 g4. g8 d2 g2. e4 c2. d4 g4. g8 d2 g2. d4\rest e h e d g2. d4\rest e h e d g2.
   d4 d2 dis4 e h h h h
  }
  \alternative {
  	  { e2. e4 }
  	  { e2. d4\rest }
  }
  e4 e e e e2. d4\rest e h e d g2. d4\rest fis g8[( a)] h4 h, e2.
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
    %\set Staff.instrumentName = #"S" 
    \new Voice { \global \voiceOne \sopranMusic }
    \new Voice { \global \voiceTwo \altMusic }
    \addlyrics { \stanzaOne }
    >>
   
    \new Staff = "staff" <<
    %\set Staff.instrumentName = #"T"   
    %\clef "G_8"
     \new Voice { \global \voiceOne \tenorMusic }
     \new Lyrics \with { alignAboveContext = "staff" } { \menWords }
     \new Voice { \global \voiceTwo \bassMusic }
     %\addlyrics { \stanzaOne }  
    >>
   >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 60
  \context { \Voice \remove "Dynamic_performer" }
}


 \score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}


\score {
  \unfoldRepeats
  \new Voice { \global \sopranMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

 \score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}